/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage.internal;

import com.aptana.core.CorePlugin;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.AnalyticsInfo;
import com.aptana.usage.FeatureEvent;
import com.aptana.usage.IStudioAnalytics;
import com.aptana.usage.UsagePlugin;
import com.aptana.usage.internal.DefaultAnalyticsInfo;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;

public class SendPingJob
extends Job {
    private static final String STUDIO_FIRST_RUN = "studio.first-run";
    private static final String STUDIO_ENROLL = "ti.enroll";
    private static final String STUDIO_START = "ti.start";
    private static final String STUDIO_END = "ti.end";
    private static final Map<String, String> STUDIO_NATURE_MAP = CollectionsUtil.newMap((Object[])new String[]{"com.aptana.projects.webnature", "web", "com.aptana.editor.php.phpNature", "php", "com.aptana.ruby.core.rubynature", "ruby", "org.radrails.rails.core.railsnature", "rails"});
    private static IResourceChangeListener projectDeleteListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 4) {
                try {
                    String projectType;
                    IProject project = event.getResource().getProject();
                    IProjectDescription description = project.getDescription();
                    Object[] natures = description.getNatureIds();
                    if (!ArrayUtil.isEmpty((Object[])natures) && !StringUtil.isEmpty((String)(projectType = (String)STUDIO_NATURE_MAP.get(natures[0])))) {
                        SendPingJob.sendProjectDeleteEvent(project, projectType);
                    }
                }
                catch (Exception e) {
                    UsagePlugin.logError(e);
                }
            }
        }
    };

    public SendPingJob() {
        super("Sending ping");
        this.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.earlyStartup();
        return Status.OK_STATUS;
    }

    public void earlyStartup() {
        this.sendFirstRunEvent();
        this.enroll();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(projectDeleteListener, 4);
        this.sendStartEvent();
    }

    private void sendStartEvent() {
        if (!EclipseUtil.isTesting()) {
            SendPingJob.sendEvent(new AnalyticsEvent(STUDIO_START, STUDIO_START, null));
        }
    }

    private boolean enroll() {
        IScopeContext scope = ConfigurationScope.INSTANCE;
        boolean hasEnrolled = Platform.getPreferencesService().getBoolean("com.aptana.usage", "has_enrolled", false, new IScopeContext[]{scope});
        if (!hasEnrolled) {
            AnalyticsInfo info = UsagePlugin.getDefault().getAnalyticsInfoManager().getInfo("com.aptana.usage.analytics");
            String guid = info.getAppGuid();
            if (new DefaultAnalyticsInfo().getAppGuid().equals(guid)) {
                Map payload = CollectionsUtil.newInOrderMap((Object[])new String[]{"guid", guid, "mid", CorePlugin.getMID()});
                SendPingJob.sendEvent(new AnalyticsEvent(STUDIO_ENROLL, STUDIO_ENROLL, payload));
            }
            IEclipsePreferences store = scope.getNode("com.aptana.usage");
            store.putBoolean("has_enrolled", true);
            try {
                store.flush();
                return true;
            }
            catch (BackingStoreException e) {
                UsagePlugin.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    private static void sendEvent(AnalyticsEvent featureEvent) {
        UsagePlugin plugin = UsagePlugin.getDefault();
        if (plugin == null) {
            return;
        }
        IStudioAnalytics analytics = plugin.getStudioAnalytics();
        if (analytics == null) {
            return;
        }
        analytics.sendEvent(featureEvent);
    }

    private boolean sendFirstRunEvent() {
        IScopeContext scope = ConfigurationScope.INSTANCE;
        boolean hasRun = Platform.getPreferencesService().getBoolean("com.aptana.usage", "ide-has-run", false, new IScopeContext[]{scope});
        if (!hasRun && !(hasRun = Platform.getPreferencesService().getBoolean("com.aptana.db", "ide-has-run", false, new IScopeContext[]{scope}))) {
            SendPingJob.sendEvent(new AnalyticsEvent(STUDIO_FIRST_RUN, STUDIO_FIRST_RUN, null));
            IEclipsePreferences store = scope.getNode("com.aptana.usage");
            store.putBoolean("ide-has-run", true);
            try {
                store.flush();
                return true;
            }
            catch (BackingStoreException e) {
                UsagePlugin.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    private static void sendProjectDeleteEvent(IProject project, String projectType) {
        Map payload = CollectionsUtil.newMap((Object[])new String[]{"name", project.getName()});
        SendPingJob.sendEvent(new FeatureEvent("project.delete." + projectType, payload));
    }

    public void shutdown() {
        this.cancel();
        if (projectDeleteListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(projectDeleteListener);
        }
        if (!EclipseUtil.isTesting()) {
            SendPingJob.sendEvent(new AnalyticsEvent(STUDIO_END, STUDIO_END, null));
        }
    }
}

